const fields = ['apiKey', 'model', 'enabled', 'autoScan', 'darkMode'];

// Load settings
chrome.storage.sync.get(fields, (data) => {
  if (data.apiKey) document.getElementById('apiKey').value = data.apiKey;
  if (data.model) document.getElementById('model').value = data.model;
  document.getElementById('enabled').checked = data.enabled !== false;
  document.getElementById('autoScan').checked = data.autoScan !== false;
  document.getElementById('darkMode').checked = data.darkMode !== false;
});

// Save
document.getElementById('saveBtn').addEventListener('click', () => {
  const settings = {
    apiKey: document.getElementById('apiKey').value.trim(),
    model: document.getElementById('model').value,
    enabled: document.getElementById('enabled').checked,
    autoScan: document.getElementById('autoScan').checked,
    darkMode: document.getElementById('darkMode').checked
  };

  chrome.storage.sync.set(settings, () => {
    const status = document.getElementById('status');
    status.textContent = '✓ Settings saved successfully';
    status.className = 'status success';
    setTimeout(() => { status.textContent = ''; }, 3000);
  });
});
