// Load current state
chrome.runtime.sendMessage({ type: 'GET_SETTINGS' }, (data) => {
  if (!data) return;

  // Enable toggle
  const toggle = document.getElementById('enableToggle');
  toggle.checked = data.enabled !== false;

  // Plan status
  const planStatus = document.getElementById('planStatus');
  const queryStatus = document.getElementById('queryStatus');

  if (data.hasOwnKey) {
    planStatus.textContent = 'Own API Key';
    planStatus.className = 'status-value pro';
    queryStatus.textContent = 'Unlimited';
    queryStatus.className = 'status-value ok';
  } else if (data.unlimited) {
    planStatus.textContent = 'Admin';
    planStatus.className = 'status-value pro';
    queryStatus.textContent = 'Unlimited';
    queryStatus.className = 'status-value ok';
  } else {
    const used = data.queryCount || 0;
    const limit = data.freeLimit || 10;
    const remaining = Math.max(0, limit - used);

    if (remaining <= 0) {
      planStatus.textContent = 'Free (expired)';
      planStatus.className = 'status-value warn';
      queryStatus.textContent = '0 remaining';
      queryStatus.className = 'status-value warn';
    } else {
      planStatus.textContent = 'Free';
      planStatus.className = 'status-value ok';
      queryStatus.textContent = remaining + ' of ' + limit + ' left';
      queryStatus.className = remaining <= 3 ? 'status-value warn' : 'status-value ok';
    }
  }

  // Model status
  const modelStatus = document.getElementById('modelStatus');
  const modelName = data.model || 'claude-sonnet-4-20250514';
  if (modelName.includes('sonnet')) {
    modelStatus.textContent = 'Sonnet 4';
  } else if (modelName.includes('haiku')) {
    modelStatus.textContent = 'Haiku 4.5';
  } else {
    modelStatus.textContent = modelName.split('-').slice(0, 2).join(' ');
  }
  modelStatus.className = 'status-value ok';
});

// Toggle enable/disable
document.getElementById('enableToggle').addEventListener('change', (e) => {
  chrome.storage.sync.set({ enabled: e.target.checked });
  chrome.tabs.query({}, (tabs) => {
    tabs.forEach(tab => {
      if (tab.id) {
        chrome.tabs.sendMessage(tab.id, {
          type: 'TOGGLE_ENABLED',
          enabled: e.target.checked
        }).catch(() => {});
      }
    });
  });
});

// Open widget on current tab
document.getElementById('openWidgetBtn').addEventListener('click', async () => {
  const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
  if (tab?.id) {
    chrome.tabs.sendMessage(tab.id, { type: 'OPEN_WIDGET' }).catch(() => {
      chrome.scripting.executeScript({
        target: { tabId: tab.id },
        files: ['content.js']
      }).then(() => {
        setTimeout(() => {
          chrome.tabs.sendMessage(tab.id, { type: 'OPEN_WIDGET' }).catch(() => {});
        }, 500);
      }).catch(() => {});
    });
  }
  window.close();
});

// Settings button
document.getElementById('settingsBtn').addEventListener('click', () => {
  chrome.runtime.openOptionsPage();
  window.close();
});
